# Configuração PayFort - Portal CPF Regular

Este documento explica como configurar a integração com a API PayFort para o Portal CPF Regular.

## 📋 Pré-requisitos

1. **Conta PayFort aprovada** - Você precisa ter uma conta aprovada no PayFort
2. **API Key válida** - Obtenha sua chave de API no dashboard do PayFort

## 🔧 Configuração

### 1. Obter Credenciais

1. Acesse seu dashboard PayFort
2. Vá para **Settings => API Credentials**
3. Gere ou copie sua API Key

### 2. Configurar Credenciais

Edite o arquivo `payfort-config.php` e substitua:

```php
$PAYFORT_CONFIG = [
    'api_key' => 'SUA_API_KEY_AQUI', // Substitua pela sua API Key real
    'cashin_url' => 'https://cashin.safepayments.cloud',
    'cashout_url' => 'https://cashout.safepayments.cloud',
    'webhook_url' => 'https://portal.cpfregular.is/webhook.php',
    'environment' => 'production', // 'sandbox' ou 'production'
    // ... outras configurações
];
```

### 3. Configurar Webhook

No dashboard PayFort:
1. Vá para **Settings => Webhooks**
2. Configure a URL: `https://portal.cpfregular.is/webhook.php`
3. Selecione os eventos que deseja receber:
   - `cashin.created` - QR Code PIX criado
   - `cashin.paid` - Pagamento recebido
   - `cashin.refund` - Reembolso
   - `cashin.infraction` - Infração

## 🧪 Testando a Integração

Execute o arquivo de teste para verificar se tudo está funcionando:

```bash
php test-payfort-integration.php
```

Ou acesse via navegador:
```
https://portal.cpfregular.is/test-payfort-integration.php
```

## 📚 Documentação da API

A integração foi baseada na documentação oficial do PayFort:

- **Documentação**: https://docs.payfortbr.com/docs/Welcome
- **Cash-In**: https://docs.payfortbr.com/docs/Cash-In
- **Webhooks**: https://docs.payfortbr.com/docs/Webhooks

## 🔄 Endpoints da API

### Gerar PIX
```
POST /gerar-pix.php
Content-Type: application/json

{
    "action": "gerar_pix",
    "nome": "João da Silva",
    "cpf": "12345678901",
    "email": "joao@exemplo.com",
    "telefone": "11999999999",
    "valor": 50.00,
    "descricao": "Regularização Fiscal"
}
```

### Verificar Status por Transaction ID
```
POST /gerar-pix.php
Content-Type: application/json

{
    "action": "verificar_status",
    "transaction_id": "12345"
}
```

### Verificar Status por Order ID
```
POST /gerar-pix.php
Content-Type: application/json

{
    "action": "verificar_status_order",
    "order_id": "CPF_1234567890_8901"
}
```

## 📊 Resposta da API

### Sucesso na Geração de PIX
```json
{
    "success": true,
    "transaction_id": 12345,
    "external_id": "uuid-external-id",
    "order_id": "CPF_1234567890_8901",
    "pix_code": "00020126580014br.gov.bcb.pix...",
    "pix_qr_code": "iVBORw0KGgoAAAANSUhEUgAAAOQ...",
    "expires_at": "2025-01-15 15:30:00",
    "amount": 50.00,
    "status": "created"
}
```

### Status de Pagamento
```json
{
    "success": true,
    "status": "paid",
    "paid_at": "2025-01-15T15:25:00.000Z",
    "end_to_end_id": "E12345678901234567890123456789012"
}
```

## 🔔 Webhooks

O sistema recebe webhooks do PayFort com os seguintes eventos:

### Pagamento Recebido
```json
{
    "transactionId": 12345,
    "object": "cashin",
    "status": "paid",
    "method": "pix",
    "value": 5000,
    "endToEndId": "E12345678901234567890123456789012",
    "processedAt": "2025-01-15T15:25:00.000Z",
    "payer": {
        "name": "João da Silva",
        "documentId": "12345678901",
        "bankName": "Banco do Brasil",
        "bankIspb": "00000000"
    },
    "orderId": "CPF_1234567890_8901"
}
```

## 🚨 Troubleshooting

### Erro: "API Key não configurada"
- Verifique se você configurou a API Key no arquivo `payfort-config.php`
- Certifique-se de que a API Key está correta

### Erro: "Invalid token"
- Verifique se a API Key está correta
- Certifique-se de que a conta está ativa no PayFort

### Erro: "No active acquirer"
- Entre em contato com o suporte PayFort
- Verifique se sua conta está aprovada para transações

### Webhook não recebido
- Verifique se a URL do webhook está configurada corretamente
- Teste a URL do webhook manualmente
- Verifique os logs do servidor

## 📝 Logs

Os logs são salvos em:
- `webhook_logs.txt` - Logs dos webhooks recebidos
- Logs do PHP - Erros e informações de debug

## 🔒 Segurança

- **NUNCA** commite o arquivo `payfort-config.php` com credenciais reais
- Use variáveis de ambiente em produção
- Mantenha suas credenciais seguras
- Monitore os logs regularmente

## 📞 Suporte

Para suporte técnico:
- **PayFort**: Consulte a documentação oficial
- **Portal**: Verifique os logs e execute os testes de integração

---

**Última atualização**: Janeiro 2025
**Versão da integração**: 2.0
